/* Bibloteca de funcions matematiques. */


/* Inclueix les biblioteques necessaries: */
#include "boolean.h"


/* Definicio de funcions: */
long factorial(int n); /* Calcula el factorial de un nombre. */
int nombre_combinatori(int n, int m); /* Calcula el nombre combinatori de n i m. */
double potencia(double x, int n); /* Calcula la potencia n-essima de x. */
int mcd(int a, int b); /* Calcula el Maxim Comu Divisor de dos nombres. */
boolean primer(int n); /* Calcula si un nombre es primer o no. */
int seguent_primer(int n); /* Calcula el nombre primer que ve despres d'un donat. */
double arrel_quadrada(float n);
//Falten: quadrat_perfecte, cub_perfecte.

/* Funcio que calcula el factorial de un nombre: */
long factorial(int n)
{
     /* Declara variables internes (locals): */
     int i, num_factorial = 1;

     /* Calcula el factorial: */
     for (i=1; i<=n; i++)
         num_factorial = num_factorial * i;

     /* Retorna el factorial: */
     return num_factorial;
}


/* Calcula el nombre combinatori de n i m. */
int nombre_combinatori(int n, int m)
{
    /* Declara variables internes (locals): */
    int divisor, dividend;
    
    /* Calcula el dividend de la formula: */
    dividend = factorial(n);
    /* Calcula el divisor de la formula: */
    divisor = factorial(m) * factorial(n-m);

    /* Retorna el nombre combinatori, segons la formula: */
    return dividend / divisor;
}


/* Calcula la potencia n-essima de x: */
double potencia(double x, int n)
{
       /* Declara variables internes (locals): */
       int i;
       double resultat = 1;

       /* Calcula x elevat a n: */
       for (i=0; i<n; i++)
           resultat = resultat * x;
       
       /* Retorna el resultat (x^n): */
       return resultat;
}


/* Funcio que calcula el Maxim Comu Divisor de dos nombres: */
int mcd(int a, int b)
{
    /* Mentre a sigui diferent de b: */
    while (a != b)
    {
        /* Si a es mes gran, se li resta b: */  
        if (a > b) { a = a - b; }
        /* ...i si no (es mes petit), se resta en b el valor de a: */
        else { b = b - a; }
    }
}


/* Funcio que calcula si un nombre es primer o no: */
boolean primer(int n)
{
        /* Declara les variables necessaries: */
        int x = 2; /* primer numero divisor. */
        boolean es_primer = TRUE;

        /* Si el nombre enviat es negatiu, es passa a positiu: */
        if (n < 0) { n *= -1; }

        /* Fa el bucle mentre no es detecti que no sigui primer o no arrivi a 2: */
        while (es_primer && x < n / 2) /* <-- El limit es la meitat del nombre (cap nombre es divisible per un que sigui superior a la seva meitat). */
        /* while (es_primer && x < n / x) <-- aquesta solucio es la mes rapida perque solament arriva a dividir fins a n / x. */
        {
            /* Si el nombre es divisible per x, vol dir que no es primer: */
            if (n % x == 0) { es_primer = FALSE; }
            /* Es decrementa el divisor: */
            x++;
        }
        
        /* Retorna si es primer o no: */
        return es_primer;
}


/* Funcio que calcula el nombre primer que ve despres d'un donat: */
int seguent_primer(int n)
{
        /* Si el nombre enviat es negatiu, es passa a positiu: */
        if (n < 0) { n *= -1; }

        /* Mentre no es detecti que es primer, s'incrementa i torna a comprovar: */
        do { n++; } while (!primer(n));

        /* Si hem arrivat aqui es que ha detectat un primer i el retornem: */
        return n;
}
